define([
		'app',
		'LearnMoreConstants',
		'LearnMoreSummaryController'
	],
	function (app) {
		'use strict';

		app.config(function ($stateProvider) {
			$stateProvider
				.state('main.auth.two-panel.secondary-navigation.learn-more', {
					url: '/learn-more',
					appNavIndex: 5,
					containerClass: 'learn-more',
					data: {
						appletName: 'Learn More',
						moduleName: 'Learn More',
						panel: 'secondary',
                        baseStateName : 'main.auth.two-panel.secondary-navigation.learn-more',
                        initialState : 'summary',
                        icon : 'gradcap',
                        paramSections : [
                            {
                                paramValue : 'fitness',
                                sectionName : 'Fitness',
                                sectionIndex : 1,
                                backState : '^',
                                iconClass: 'icon icon-learnmore-fitness'
                            },
							{
								paramValue : 'health',
								sectionName : 'Health',
								sectionIndex : 2,
								backState : '^',
                                iconClass: 'icon icon-learnmore-health'
							},
							{
								paramValue : 'nutrition',
								sectionName : 'Nutrition',
								sectionIndex : 3,
								backState : '^',
                                iconClass: 'icon icon-learnmore-nutrition'
							},
							{
								paramValue : 'mood',
								sectionName : 'Mood',
								sectionIndex : 4,
								backState : '^',
                                iconClass: 'icon icon-learnmore-mood'
							}
                        ]
					},
					views : {
						'primary@main.auth.two-panel': {
							templateUrl: 'src/modules/learn-more/pages/learn-more-placeholder_template.html'
						}
					}
				})
				.state('main.auth.two-panel.secondary-navigation.learn-more.summary', {
					url: '/{section:fitness|health|nutrition|mood}/summary',
					data: {
						panel : 'primary',
						backState : '^'
					},
					views : {
						'primary@main.auth.two-panel': {
                            templateUrl: 'src/modules/learn-more/pages/summary/learn-more-summary_template.html',
							controller: 'LearnMoreSummaryController'
						}
					}
				});
		});
	}
);
